/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.Server;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.gui.ICompassData;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.gui.IGuiTimer;
import noppes.npcs.api.gui.IItemSlot;
import noppes.npcs.api.gui.ILabel;
import noppes.npcs.api.gui.IOverlayHUD;
import noppes.npcs.api.gui.ITexturedRect;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemSlotWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTimerWrapper;
import noppes.npcs.client.gui.custom.components.CustomGuiLabel;
import noppes.npcs.client.gui.custom.components.CustomGuiTexturedRect;
import noppes.npcs.client.gui.custom.components.CustomGuiTimer;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.data.PlayerCompassHUDData;
import noppes.npcs.util.CustomNPCsScheduler;

public class PlayerOverlayHUD
implements IOverlayHUD {
    public boolean isMoved = false;
    private byte[] showElementTypes;
    private final double[] windowSize = new double[]{0.0, 0.0};
    public List<Integer> keyPress = new ArrayList<Integer>();
    public List<Integer> mousePress = new ArrayList<Integer>();
    private int offsetType = 0;
    public int questID = 0;
    Map<Integer, List<ICustomGuiComponent>> components = new TreeMap<Integer, List<ICustomGuiComponent>>();
    private final Map<Integer, List<IItemSlot>> slots = new TreeMap<Integer, List<IItemSlot>>();
    private final TreeMap<Integer, TreeMap<Integer, IGuiComponent>> guiComponents = new TreeMap();
    private final TreeMap<Integer, TreeMap<Integer, IItemSlot>> guiSlots = new TreeMap();
    private boolean update = false;
    private EntityPlayerMP player = null;
    public PlayerCompassHUDData compassData = new PlayerCompassHUDData();
    public String currentGUI = "";

    public PlayerOverlayHUD() {
        this.showElementTypes = new byte[22];
        for (int i = 0; i < 22; ++i) {
            this.showElementTypes[i] = 1;
        }
    }

    @Override
    public IItemSlot addItemSlot(int orientationType, int x, int y) {
        return this.addItemSlot(orientationType, x, y, ItemScriptedWrapper.AIR);
    }

    @Override
    public IItemSlot addItemSlot(int orientationType, int x, int y, IItemStack stack) {
        CustomGuiItemSlotWrapper slot = new CustomGuiItemSlotWrapper(x, y, stack);
        if (!this.slots.containsKey(orientationType)) {
            this.slots.put(orientationType, new ArrayList());
        }
        this.slots.get(orientationType).add(slot);
        return slot;
    }

    @Override
    public ILabel addLabel(int id, int orientationType, String label, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        ICustomGuiComponent component = this.getComponent(orientationType, id);
        if (component instanceof CustomGuiLabelWrapper) {
            CustomGuiLabelWrapper l = (CustomGuiLabelWrapper)component;
            l.setText(label);
            l.setPos(x, y);
            l.setSize(width, height);
            return l;
        }
        if (component != null) {
            this.components.get(orientationType).remove(component);
        }
        CustomGuiLabelWrapper l = new CustomGuiLabelWrapper(id, label, x, y, width, height);
        if (!this.components.containsKey(orientationType)) {
            this.components.put(orientationType, new ArrayList());
        }
        this.components.get(orientationType).add(l);
        return l;
    }

    @Override
    public ILabel addLabel(int id, int orientationType, String label, int x, int y, int width, int height, int color) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        ICustomGuiComponent component = this.getComponent(orientationType, id);
        if (component instanceof CustomGuiLabelWrapper) {
            CustomGuiLabelWrapper l = (CustomGuiLabelWrapper)component;
            l.setText(label);
            l.setPos(x, y);
            l.setSize(width, height);
            l.setColor(color);
            return l;
        }
        if (component != null) {
            this.components.get(orientationType).remove(component);
        }
        CustomGuiLabelWrapper l = new CustomGuiLabelWrapper(id, label, x, y, width, height, color);
        if (!this.components.containsKey(orientationType)) {
            this.components.put(orientationType, new ArrayList());
        }
        this.components.get(orientationType).add(l);
        return l;
    }

    @Override
    public ITexturedRect addTexturedRect(int id, int orientationType, String texture, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        ICustomGuiComponent component = this.getComponent(orientationType, id);
        if (component instanceof CustomGuiTexturedRectWrapper) {
            CustomGuiTexturedRectWrapper txtr = (CustomGuiTexturedRectWrapper)component;
            txtr.setTexture(texture);
            txtr.setPos(x, y);
            txtr.setSize(width, height);
            return txtr;
        }
        if (component != null) {
            this.components.get(orientationType).remove(component);
        }
        CustomGuiTexturedRectWrapper txtr = new CustomGuiTexturedRectWrapper(id, texture, x, y, width, height);
        if (!this.components.containsKey(orientationType)) {
            this.components.put(orientationType, new ArrayList());
        }
        this.components.get(orientationType).add(txtr);
        return txtr;
    }

    @Override
    public ITexturedRect addTexturedRect(int id, int orientationType, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        ICustomGuiComponent component = this.getComponent(orientationType, id);
        if (component instanceof CustomGuiTexturedRectWrapper) {
            CustomGuiTexturedRectWrapper txtr = (CustomGuiTexturedRectWrapper)component;
            txtr.setTexture(texture);
            txtr.setPos(x, y);
            txtr.setSize(width, height);
            txtr.setTextureOffset(textureX, textureY);
            return txtr;
        }
        if (component != null) {
            this.components.get(orientationType).remove(component);
        }
        CustomGuiTexturedRectWrapper txtr = new CustomGuiTexturedRectWrapper(id, texture, x, y, width, height, textureX, textureY);
        if (!this.components.containsKey(orientationType)) {
            this.components.put(orientationType, new ArrayList());
        }
        this.components.get(orientationType).add(txtr);
        return txtr;
    }

    @Override
    public IGuiTimer addTimer(int id, int orientationType, long start, long end, int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        ICustomGuiComponent component = this.getComponent(orientationType, id);
        if (component instanceof CustomGuiTimerWrapper) {
            CustomGuiTimerWrapper timer = (CustomGuiTimerWrapper)component;
            timer.setTime(start, end);
            timer.setPos(x, y);
            timer.setSize(width, height);
            timer.reverse = start > end;
            return timer;
        }
        if (component != null) {
            this.components.get(orientationType).remove(component);
        }
        CustomGuiTimerWrapper timer = new CustomGuiTimerWrapper(id, start, end, x, y, width, height);
        if (!this.components.containsKey(orientationType)) {
            this.components.put(orientationType, new ArrayList());
        }
        this.components.get(orientationType).add(timer);
        return timer;
    }

    @Override
    public IGuiTimer addTimer(int id, int orientationType, long start, long end, int x, int y, int width, int height, int color) {
        if (width == 0 || height == 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        ICustomGuiComponent component = this.getComponent(orientationType, id);
        if (component instanceof CustomGuiTimerWrapper) {
            CustomGuiTimerWrapper timer = (CustomGuiTimerWrapper)component;
            timer.setTime(start, end);
            timer.setPos(x, y);
            timer.setSize(width, height);
            timer.setColor(color);
            return timer;
        }
        if (component != null) {
            this.components.get(orientationType).remove(component);
        }
        CustomGuiTimerWrapper timer = new CustomGuiTimerWrapper(id, start, end, x, y, width, height, color);
        if (!this.components.containsKey(orientationType)) {
            this.components.put(orientationType, new ArrayList());
        }
        this.components.get(orientationType).add(timer);
        return timer;
    }

    @Override
    public void clear() {
        this.components.clear();
        this.slots.clear();
        this.guiComponents.clear();
        this.guiSlots.clear();
        this.update = true;
    }

    public void clearGuiComponents() {
        this.guiComponents.clear();
        this.guiSlots.clear();
    }

    @Override
    public ICompassData getCompassData() {
        return this.compassData;
    }

    @Override
    public ICustomGuiComponent getComponent(int orientationType, int componentID) {
        if (!this.components.containsKey(orientationType)) {
            return null;
        }
        for (ICustomGuiComponent component : this.components.get(orientationType)) {
            if (component.getId() != componentID) continue;
            return component;
        }
        return null;
    }

    @Override
    public ICustomGuiComponent[] getComponents() {
        ArrayList list = new ArrayList();
        for (int type : this.components.keySet()) {
            list.addAll(this.components.get(type));
        }
        return list.toArray(new ICustomGuiComponent[0]);
    }

    @Override
    public ICustomGuiComponent[] getComponents(int orientationType) {
        ArrayList list = new ArrayList();
        if (!this.components.containsKey(orientationType)) {
            return new ICustomGuiComponent[0];
        }
        return this.components.get(orientationType).toArray(new ICustomGuiComponent[0]);
    }

    public TreeMap<Integer, TreeMap<Integer, IGuiComponent>> getGuiComponents() {
        if (this.guiComponents.size() != this.components.size()) {
            for (int type : this.components.keySet()) {
                if (!this.guiComponents.containsKey(type)) {
                    this.guiComponents.put(type, new TreeMap());
                }
                for (ICustomGuiComponent component : this.components.get(type)) {
                    if (component instanceof CustomGuiLabelWrapper) {
                        CustomGuiLabel lbl = CustomGuiLabel.fromComponent((CustomGuiLabelWrapper)component);
                        this.guiComponents.get(type).put(lbl.getId(), lbl);
                        continue;
                    }
                    if (component instanceof CustomGuiTexturedRectWrapper) {
                        CustomGuiTexturedRect rect = CustomGuiTexturedRect.fromComponent((CustomGuiTexturedRectWrapper)component);
                        rect.id -= 200;
                        this.guiComponents.get(type).put(rect.getId(), rect);
                        continue;
                    }
                    if (!(component instanceof CustomGuiTimerWrapper)) continue;
                    CustomGuiTimer time = CustomGuiTimer.fromComponent((CustomGuiTimerWrapper)component);
                    this.guiComponents.get(type).put(time.getId(), time);
                }
            }
        }
        for (int type : this.guiComponents.keySet()) {
            if (!this.components.containsKey(type)) continue;
            Iterator<Object> iterator = this.guiComponents.get(type).keySet().iterator();
            while (iterator.hasNext()) {
                int[] xy;
                int i = (Integer)iterator.next();
                IGuiComponent gc = this.guiComponents.get(type).get(i);
                int id = (gc instanceof CustomGuiTexturedRect ? 200 : 0) + i;
                ICustomGuiComponent bc = this.getComponent(type, id);
                if (gc == null || bc == null || (xy = gc.getPosXY())[0] == bc.getPosX() && xy[1] == bc.getPosY()) continue;
                gc.setPosXY(bc.getPosX(), bc.getPosY());
            }
        }
        return this.guiComponents;
    }

    public TreeMap<Integer, TreeMap<Integer, IItemSlot>> getGuiSlots() {
        if (this.guiSlots.size() != this.slots.size()) {
            TreeMap<Integer, Integer> ids = new TreeMap<Integer, Integer>();
            for (int type : this.components.keySet()) {
                if (!ids.containsKey(type)) {
                    ids.put(type, 0);
                }
                for (ICustomGuiComponent component : this.components.get(type)) {
                    if ((Integer)ids.get(type) >= component.getId()) continue;
                    ids.put(type, component.getId());
                }
            }
            for (int type : this.slots.keySet()) {
                if (!this.guiSlots.containsKey(type)) {
                    this.guiSlots.put(type, new TreeMap());
                }
                int id = ids.containsKey(type) ? (Integer)ids.get(type) + 1 : 1;
                for (IItemSlot slot : this.slots.get(type)) {
                    this.guiSlots.get(type).put(id++, slot);
                }
            }
        }
        return this.guiSlots;
    }

    public int[] getKeyPressed() {
        int[] ids = new int[this.keyPress.size()];
        int i = 0;
        Iterator<Integer> iterator = this.keyPress.iterator();
        while (iterator.hasNext()) {
            int key;
            ids[i] = key = iterator.next().intValue();
            ++i;
        }
        return ids;
    }

    public int[] getMousePressed() {
        int[] ids = new int[this.mousePress.size()];
        int i = 0;
        Iterator<Integer> iterator = this.mousePress.iterator();
        while (iterator.hasNext()) {
            int key;
            ids[i] = key = iterator.next().intValue();
            ++i;
        }
        return ids;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound hudNBT = new NBTTagCompound();
        hudNBT.func_74773_a("ShowElementTypes", this.showElementTypes);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagDouble(this.windowSize[0]));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.windowSize[1]));
        hudNBT.func_74782_a("WindowSize", (NBTBase)list);
        hudNBT.func_74783_a("KeyPress", this.getKeyPressed());
        hudNBT.func_74783_a("MousePress", this.getMousePressed());
        hudNBT.func_74768_a("QuestID", this.questID);
        hudNBT.func_74782_a("CompassData", (NBTBase)this.compassData.getNbt());
        list = new NBTTagList();
        for (int type : this.components.keySet()) {
            NBTTagCompound nbtComp = new NBTTagCompound();
            nbtComp.func_74774_a("OrientationType", (byte)type);
            NBTTagList compList = new NBTTagList();
            for (ICustomGuiComponent iCustomGuiComponent : this.components.get(type)) {
                compList.func_74742_a((NBTBase)((CustomGuiComponentWrapper)iCustomGuiComponent).toNBT(new NBTTagCompound()));
            }
            nbtComp.func_74782_a("components", (NBTBase)compList);
            list.func_74742_a((NBTBase)nbtComp);
        }
        hudNBT.func_74782_a("AllComponents", (NBTBase)list);
        list = new NBTTagList();
        for (int type : this.slots.keySet()) {
            NBTTagCompound nbtSlot = new NBTTagCompound();
            nbtSlot.func_74774_a("OrientationType", (byte)type);
            NBTTagList slotList = new NBTTagList();
            for (ICustomGuiComponent iCustomGuiComponent : this.slots.get(type)) {
                slotList.func_74742_a((NBTBase)((CustomGuiComponentWrapper)iCustomGuiComponent).toNBT(new NBTTagCompound()));
            }
            nbtSlot.func_74782_a("components", (NBTBase)slotList);
            list.func_74742_a((NBTBase)nbtSlot);
        }
        hudNBT.func_74782_a("AllSlots", (NBTBase)list);
        hudNBT.func_74768_a("OffsetType", this.offsetType);
        return hudNBT;
    }

    @Override
    public IItemSlot[] getSlots() {
        ArrayList list = new ArrayList();
        for (int type : this.slots.keySet()) {
            list.addAll(this.slots.get(type));
        }
        return list.toArray(new IItemSlot[0]);
    }

    @Override
    public IItemSlot[] getSlots(int orientationType) {
        if (!this.slots.containsKey(orientationType)) {
            return new IItemSlot[0];
        }
        return this.slots.get(orientationType).toArray(new IItemSlot[0]);
    }

    public double[] getWindowSize() {
        return this.windowSize;
    }

    public boolean hasMousePress(int key) {
        for (int k : this.mousePress) {
            if (k != key) continue;
            return true;
        }
        return this.mousePress.contains(key);
    }

    public boolean hasOrKeysPressed(int ... keys) {
        for (int key : keys) {
            for (int k : this.keyPress) {
                if (k != key) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isShowElementType(int type) {
        if (type < 0 || type >= 22) {
            return false;
        }
        return this.showElementTypes[type] == 1;
    }

    /*
     * Could not resolve type clashes
     */
    public void loadNBTData(NBTTagCompound compound) {
        ArrayList<ICustomGuiComponent> del;
        NBTTagList compList;
        byte type;
        int i;
        if (compound == null || !compound.func_150297_b("HUDData", 10)) {
            return;
        }
        NBTTagCompound hudNBT = compound.func_74775_l("HUDData");
        this.showElementTypes = hudNBT.func_74770_j("ShowElementTypes");
        for (int i2 = 0; i2 < 2 && i2 < hudNBT.func_150295_c("WindowSize", 6).func_74745_c(); ++i2) {
            this.windowSize[i2] = hudNBT.func_150295_c("WindowSize", 6).func_150309_d(i2);
        }
        int[] iK = hudNBT.func_74759_k("KeyPress");
        int[] iM = hudNBT.func_74759_k("MousePress");
        this.keyPress.clear();
        this.mousePress.clear();
        for (int key : iK) {
            this.keyPress.add(key);
        }
        for (int key : iM) {
            this.mousePress.add(key);
        }
        this.questID = hudNBT.func_74762_e("QuestID");
        this.compassData.load(hudNBT.func_74775_l("CompassData"));
        NBTTagList list = hudNBT.func_150295_c("AllComponents", 10);
        if (list.func_74745_c() == 0) {
            this.components.clear();
            this.guiComponents.clear();
        } else {
            for (i = 0; i < list.func_74745_c(); ++i) {
                ArrayList<Integer> ids = new ArrayList<Integer>();
                NBTTagCompound compNbt = list.func_150305_b(i);
                type = compNbt.func_74771_c("OrientationType");
                if (!this.components.containsKey(type)) {
                    this.components.put(Integer.valueOf(type), new ArrayList());
                }
                compList = compNbt.func_150295_c("components", 10);
                for (int j = 0; j < compList.func_74745_c(); ++j) {
                    int id = compList.func_150305_b(j).func_74762_e("id");
                    ids.add(id);
                    boolean has = false;
                    for (ICustomGuiComponent c : this.components.get(type)) {
                        if (c.getId() != id) continue;
                        if (c.getClass() == CustomGuiLabelWrapper.class && compList.func_150305_b(j).func_74762_e("type") != 1 || c.getClass() == CustomGuiTexturedRectWrapper.class && compList.func_150305_b(j).func_74762_e("type") != 2 || c.getClass() == CustomGuiTimerWrapper.class && compList.func_150305_b(j).func_74762_e("type") != 6) {
                            this.components.get(type).remove(c);
                            break;
                        }
                        ((CustomGuiComponentWrapper)c).fromNBT(compList.func_150305_b(j));
                        has = true;
                        break;
                    }
                    if (has) continue;
                    this.components.get(type).add(CustomGuiComponentWrapper.createFromNBT(compList.func_150305_b(j)));
                }
                del = new ArrayList<ICustomGuiComponent>();
                for (ICustomGuiComponent c : this.components.get(type)) {
                    if (ids.contains(c.getId())) continue;
                    del.add(c);
                }
                for (ICustomGuiComponent c : del) {
                    this.components.get(type).remove(c);
                }
            }
        }
        list = hudNBT.func_150295_c("AllSlots", 10);
        if (list.func_74745_c() == 0) {
            this.slots.clear();
            this.guiSlots.clear();
        } else {
            for (i = 0; i < list.func_74745_c(); ++i) {
                ArrayList<Integer> ids = new ArrayList<Integer>();
                NBTTagCompound compNbt = list.func_150305_b(i);
                type = compNbt.func_74771_c("OrientationType");
                if (!this.slots.containsKey(type)) {
                    this.slots.put(Integer.valueOf(type), new ArrayList());
                }
                compList = compNbt.func_150295_c("components", 10);
                for (int j = 0; j < compList.func_74745_c(); ++j) {
                    int id = compList.func_150305_b(j).func_74762_e("id");
                    ids.add(id);
                    boolean has = false;
                    for (IItemSlot s : this.slots.get(type)) {
                        if (s.getId() != id) continue;
                        if (s.getClass() != CustomGuiItemSlotWrapper.class) {
                            this.slots.get(type).remove(s);
                            break;
                        }
                        ((CustomGuiComponentWrapper)((Object)s)).fromNBT(compList.func_150305_b(j));
                        has = true;
                        break;
                    }
                    if (has) continue;
                    this.slots.get(type).add((CustomGuiItemSlotWrapper)CustomGuiComponentWrapper.createFromNBT(compList.func_150305_b(j)));
                }
                del = new ArrayList();
                for (IItemSlot c : this.slots.get(type)) {
                    if (ids.contains(c.getId())) continue;
                    del.add(c);
                }
                for (IItemSlot c : del) {
                    this.slots.get(type).remove(c);
                }
            }
        }
        this.offsetType = hudNBT.func_74762_e("OffsetType");
        this.guiComponents.clear();
        this.guiSlots.clear();
        this.update = false;
    }

    @Override
    public boolean removeComponent(int orientationType, int componentID) {
        if (!this.components.containsKey(orientationType)) {
            return false;
        }
        for (ICustomGuiComponent comp : this.components.get(orientationType)) {
            if (comp.getId() != componentID) continue;
            this.components.get(orientationType).remove(comp);
            this.update = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeSlot(int orientationType, int componentID) {
        if (!this.slots.containsKey(orientationType)) {
            return false;
        }
        for (IItemSlot comp : this.slots.get(orientationType)) {
            if (comp.getId() != componentID) continue;
            this.slots.get(orientationType).remove(comp);
            this.update = true;
            return true;
        }
        return false;
    }

    public NBTTagCompound saveNBTData(NBTTagCompound compound) {
        compound.func_74782_a("HUDData", (NBTBase)this.getNBT());
        return compound;
    }

    @Override
    public void setShowElementType(int type, boolean bo) {
        if (type < 0 || type >= 22) {
            return;
        }
        this.showElementTypes[type] = (byte)(bo ? 1 : 0);
    }

    @Override
    public void setShowElementType(String name, boolean bo) {
        switch (name.toLowerCase()) {
            case "all": {
                int type = 0;
                break;
            }
            case "helmet": {
                int type = 1;
                break;
            }
            case "portal": {
                int type = 2;
                break;
            }
            case "crosshairs": {
                int type = 3;
                break;
            }
            case "bosshealth": {
                int type = 4;
                break;
            }
            case "bossinfo": {
                int type = 5;
                break;
            }
            case "armor": {
                int type = 6;
                break;
            }
            case "health": {
                int type = 7;
                break;
            }
            case "food": {
                int type = 8;
                break;
            }
            case "air": {
                int type = 9;
                break;
            }
            case "hotbar": {
                int type = 10;
                break;
            }
            case "experience": {
                int type = 11;
                break;
            }
            case "text": {
                int type = 12;
                break;
            }
            case "healthmount": {
                int type = 13;
                break;
            }
            case "jumpbar": {
                int type = 14;
                break;
            }
            case "chat": {
                int type = 15;
                break;
            }
            case "player_list": {
                int type = 16;
                break;
            }
            case "debug": {
                int type = 17;
                break;
            }
            case "potion_icons": {
                int type = 18;
                break;
            }
            case "subtitles": {
                int type = 19;
                break;
            }
            case "fps_graph": {
                int type = 20;
                break;
            }
            case "vignette": {
                int type = 21;
                break;
            }
            default: {
                return;
            }
        }
        this.showElementTypes[type] = (byte)(bo ? 1 : 0);
    }

    public void setWindowSize(NBTTagList tagList) {
        if (tagList == null || tagList.func_150303_d() != 6) {
            return;
        }
        for (int i = 0; i < 2 && i < tagList.func_74745_c(); ++i) {
            this.windowSize[i] = tagList.func_150309_d(i);
        }
    }

    @Override
    public void update() {
        if (this.player != null) {
            Server.sendData(this.player, EnumPacketClient.UPDATE_HUD, this.saveNBTData(new NBTTagCompound()));
            this.update = false;
        } else {
            CustomNPCsScheduler.runTack(() -> {
                this.update = true;
            }, 500);
        }
    }

    public void updateHud(EntityPlayerMP player) {
        this.player = player;
        if (this.update) {
            Server.sendData(this.player, EnumPacketClient.UPDATE_HUD, this.saveNBTData(new NBTTagCompound()));
            this.update = false;
        }
    }
}

